﻿using System;
using Microsoft.SharePoint;

namespace GetLists
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb("blog"))
            {
               Console.WriteLine("{0} | Anzahl Listen: {0}\n",
                  web.ServerRelativeUrl,
                  web.Lists.Count);

               // Hole die Collection aller Listen
               SPListCollection allLists = web.Lists;

               // Iteriere sämtliche Listen
               foreach (SPList list in allLists)
               {
                  Console.WriteLine("{0} (Anzahl Elemente: {1}) ",
                     list.Title,
                     list.ItemCount.ToString());
                  Console.WriteLine("> BaseType: {0}",
                     list.BaseType);
                  Console.WriteLine("> BaseTemplate: {0}\n",
                     list.BaseTemplate);
               }
            }
         }
      }
   }
}